// lib/merchants.js — Complete Merchant Domain Database
// Ported from SuperPay mobile app's lib/online-retailers.ts
// This is the LOCAL FALLBACK. The extension syncs the latest list from the server.

const MERCHANT_DOMAINS = {
  // ── Popular (shown by default) ──
  'amazon.com':           { name: 'Amazon',          category: 'online_shopping', icon: '🛒', popular: true },
  'walmart.com':          { name: 'Walmart',         category: 'department_store', icon: '🏪', popular: true },
  'target.com':           { name: 'Target',          category: 'department_store', icon: '🎯', popular: true },
  'bestbuy.com':          { name: 'Best Buy',        category: 'online_shopping', icon: '💻', popular: true },
  'ebay.com':             { name: 'eBay',            category: 'online_shopping', icon: '🏷️', popular: true },
  'etsy.com':             { name: 'Etsy',            category: 'online_shopping', icon: '🎨', popular: true },
  'apple.com':            { name: 'Apple',           category: 'online_shopping', icon: '🍎', popular: true },
  'nike.com':             { name: 'Nike',            category: 'online_shopping', icon: '👟', popular: true },
  'costco.com':           { name: 'Costco',          category: 'groceries',       icon: '📦', popular: true },
  'homedepot.com':        { name: 'Home Depot',      category: 'home_improvement', icon: '🔨', popular: true },
  'lowes.com':            { name: "Lowe's",          category: 'home_improvement', icon: '🏠', popular: true },
  'wayfair.com':          { name: 'Wayfair',         category: 'online_shopping', icon: '🛋️', popular: true },

  // ── Department Stores ──
  'nordstrom.com':        { name: 'Nordstrom',       category: 'department_store', icon: '👗' },
  'macys.com':            { name: "Macy's",          category: 'department_store', icon: '🛍️' },
  'kohls.com':            { name: "Kohl's",          category: 'department_store', icon: '🏬' },
  'tjmaxx.com':           { name: 'TJ Maxx',         category: 'department_store', icon: '🏷️' },
  'marshalls.com':        { name: 'Marshalls',       category: 'department_store', icon: '🏷️' },
  'jcpenney.com':         { name: 'JCPenney',        category: 'department_store', icon: '🏬' },
  'bloomingdales.com':    { name: 'Bloomingdales',   category: 'department_store', icon: '👠' },
  'dillards.com':         { name: "Dillard's",       category: 'department_store', icon: '🏬' },
  'saksfifthavenue.com':  { name: 'Saks Fifth Avenue', category: 'department_store', icon: '💎' },
  'neimanmarcus.com':     { name: 'Neiman Marcus',   category: 'department_store', icon: '💎' },

  // ── Fashion & Apparel ──
  'adidas.com':           { name: 'Adidas',          category: 'online_shopping', icon: '👟' },
  'underarmour.com':      { name: 'Under Armour',    category: 'online_shopping', icon: '🏋️' },
  'newbalance.com':       { name: 'New Balance',     category: 'online_shopping', icon: '👟' },
  'puma.com':             { name: 'Puma',            category: 'online_shopping', icon: '👟' },
  'lululemon.com':        { name: 'Lululemon',       category: 'online_shopping', icon: '🧘' },
  'gap.com':              { name: 'Gap',             category: 'department_store', icon: '👕' },
  'oldnavy.com':          { name: 'Old Navy',        category: 'department_store', icon: '👕' },
  'hm.com':               { name: 'H&M',            category: 'department_store', icon: '👗' },
  'zara.com':             { name: 'Zara',            category: 'department_store', icon: '👗' },
  'uniqlo.com':           { name: 'Uniqlo',          category: 'department_store', icon: '👕' },
  'asos.com':             { name: 'ASOS',            category: 'online_shopping', icon: '👗' },
  'shein.com':            { name: 'Shein',           category: 'online_shopping', icon: '👗' },
  'temu.com':             { name: 'Temu',            category: 'online_shopping', icon: '📦' },

  // ── Pets ──
  'chewy.com':            { name: 'Chewy',           category: 'online_shopping', icon: '🐾' },
  'petco.com':            { name: 'Petco',           category: 'online_shopping', icon: '🐕' },
  'petsmart.com':         { name: 'PetSmart',        category: 'online_shopping', icon: '🐾' },

  // ── Electronics ──
  'newegg.com':           { name: 'Newegg',          category: 'online_shopping', icon: '🖥️' },
  'bhphotovideo.com':     { name: 'B&H Photo',       category: 'online_shopping', icon: '📷' },
  'samsung.com':          { name: 'Samsung',         category: 'online_shopping', icon: '📱' },
  'dell.com':             { name: 'Dell',            category: 'online_shopping', icon: '💻' },
  'hp.com':               { name: 'HP',              category: 'online_shopping', icon: '🖨️' },
  'microsoft.com':        { name: 'Microsoft Store', category: 'online_shopping', icon: '💻' },

  // ── Groceries ──
  'instacart.com':        { name: 'Instacart',       category: 'groceries', icon: '🥕' },
  'wholefoodsmarket.com': { name: 'Whole Foods',     category: 'groceries', icon: '🥬' },
  'kroger.com':           { name: 'Kroger',          category: 'groceries', icon: '🛒' },
  'safeway.com':          { name: 'Safeway',         category: 'groceries', icon: '🛒' },

  // ── Food Delivery ──
  'doordash.com':         { name: 'DoorDash',        category: 'dining', icon: '🍔' },
  'ubereats.com':         { name: 'Uber Eats',       category: 'dining', icon: '🍕' },
  'grubhub.com':          { name: 'Grubhub',         category: 'dining', icon: '🥡' },

  // ── Travel ──
  'expedia.com':          { name: 'Expedia',         category: 'travel', icon: '✈️' },
  'booking.com':          { name: 'Booking.com',     category: 'travel', icon: '🏨' },
  'airbnb.com':           { name: 'Airbnb',          category: 'travel', icon: '🏡' },
  'hotels.com':           { name: 'Hotels.com',      category: 'travel', icon: '🏨' },
  'priceline.com':        { name: 'Priceline',       category: 'travel', icon: '💰' },
  'vrbo.com':             { name: 'VRBO',            category: 'travel', icon: '🏠' },
  'kayak.com':            { name: 'Kayak',           category: 'travel', icon: '🔍' },
  'southwest.com':        { name: 'Southwest Airlines', category: 'travel', icon: '✈️' },
  'delta.com':            { name: 'Delta Airlines',  category: 'travel', icon: '✈️' },
  'united.com':           { name: 'United Airlines',  category: 'travel', icon: '✈️' },
  'aa.com':               { name: 'American Airlines', category: 'travel', icon: '✈️' },

  // ── Pharmacy ──
  'cvs.com':              { name: 'CVS',             category: 'drugstores', icon: '💊' },
  'walgreens.com':        { name: 'Walgreens',       category: 'drugstores', icon: '💊' },

  // ── Streaming ──
  'netflix.com':          { name: 'Netflix',         category: 'streaming', icon: '🎬' },
  'spotify.com':          { name: 'Spotify',         category: 'streaming', icon: '🎵' },
  'disneyplus.com':       { name: 'Disney+',         category: 'streaming', icon: '🏰' },
  'hulu.com':             { name: 'Hulu',            category: 'streaming', icon: '📺' },
  'max.com':              { name: 'HBO Max',         category: 'streaming', icon: '🎭' },
  'tv.apple.com':         { name: 'Apple TV+',       category: 'streaming', icon: '📺' },
  'youtube.com':          { name: 'YouTube Premium', category: 'streaming', icon: '▶️' },
  'peacocktv.com':        { name: 'Peacock',         category: 'streaming', icon: '🦚' },

  // ── Transit ──
  'uber.com':             { name: 'Uber',            category: 'transit', icon: '🚗' },
  'lyft.com':             { name: 'Lyft',            category: 'transit', icon: '🚙' },

  // ── Gas ──
  'shell.com':            { name: 'Shell',           category: 'gas', icon: '⛽' },
  'exxon.com':            { name: 'Exxon Mobil',     category: 'gas', icon: '⛽' },
  'chevron.com':          { name: 'Chevron',         category: 'gas', icon: '⛽' },

  // ── Home & Furniture ──
  'ikea.com':             { name: 'IKEA',            category: 'home_improvement', icon: '🪑' },
  'potterybarn.com':      { name: 'Pottery Barn',    category: 'home_improvement', icon: '🏺' },
  'crateandbarrel.com':   { name: 'Crate & Barrel',  category: 'home_improvement', icon: '🏡' },
  'westelm.com':          { name: 'West Elm',        category: 'home_improvement', icon: '🛋️' },
  'overstock.com':        { name: 'Overstock',       category: 'online_shopping', icon: '📦' },

  // ── Beauty ──
  'sephora.com':          { name: 'Sephora',         category: 'online_shopping', icon: '💄' },
  'ulta.com':             { name: 'Ulta',            category: 'online_shopping', icon: '💅' },
  'bathandbodyworks.com': { name: 'Bath & Body Works', category: 'online_shopping', icon: '🧴' },
};

const CATEGORY_LABELS = {
  dining: 'Dining',
  groceries: 'Groceries',
  gas: 'Gas',
  travel: 'Travel',
  entertainment: 'Entertainment',
  online_shopping: 'Online Shopping',
  streaming: 'Streaming',
  drugstores: 'Drugstores',
  home_improvement: 'Home Improvement',
  transit: 'Transit',
  department_store: 'Department Store',
  other: 'Other',
};

function detectMerchant(url) {
  try {
    let hostname = new URL(url).hostname.toLowerCase();
    if (hostname.startsWith('www.')) hostname = hostname.slice(4);

    for (const [domain, info] of Object.entries(MERCHANT_DOMAINS)) {
      if (hostname === domain || hostname.endsWith('.' + domain)) {
        return { ...info, domain };
      }
    }
  } catch {}

  return null;
}

function detectMerchantFromTitle(title) {
  if (!title) return null;
  const cleaned = title.toLowerCase();

  for (const [domain, info] of Object.entries(MERCHANT_DOMAINS)) {
    const brandName = info.name.toLowerCase();
    if (cleaned.includes(brandName)) {
      return { ...info, domain };
    }
  }
  return null;
}

// These are accessible to content.js and background.js
if (typeof window !== 'undefined') {
  window.MERCHANT_DOMAINS = MERCHANT_DOMAINS;
  window.CATEGORY_LABELS = CATEGORY_LABELS;
  window.detectMerchant = detectMerchant;
  window.detectMerchantFromTitle = detectMerchantFromTitle;
}